<?php
	header('X-Frame-Options: DENY');
	header('X-XSS-Protection: 1; mode=block');
	header('Content-Type: text/html; charset=utf-8');

	include('../../../inc/db.php');
	include('../../../inc/classes/class.template.php');

	$conf->time_zone = isset($conf->time_zone) ? $conf->time_zone : 'Europe/Moscow';

	date_default_timezone_set($conf->time_zone);

	$tpl = new Template;
	$tpl->dir = '../tpl/ajax/elements/';

	$id = isset($_POST['server']) ? intval($_POST['server']) : 0;

	if($id)
		$servers = $pdo->query('SELECT `id`, `name` FROM `servers` WHERE `id`="'.$id.'" LIMIT 1');
	else
		$servers = $pdo->query('SELECT `id`, `name` FROM `servers` WHERE `type`!="0" ORDER BY `trim`');

	$servers->setFetchMode(PDO::FETCH_OBJ);

	$users = array();
	$aType = array('a' => 'Ник и пароль', 'ce' => 'SteamID', 'ca' => 'SteamID и пароль');

	while($server = $servers->fetch())
	{
		$i = 0;

		$tpl->result['admins'] = '';

		$admins = $pdo->query('SELECT `id`, `name`, `type`, `user_id`, `active`, `link`, `cause`, `pirce` FROM `admins` WHERE `server`="'.$server->id.'"');
				  $admins->setFetchMode(PDO::FETCH_OBJ);
		while($admin = $admins->fetch())
		{
			$i += 1;

			$privileges = '';

			$services = $pdo->query('SELECT `services`.`name`, `services`.`show_adm` FROM `admins_services` LEFT JOIN `services` ON `admins_services`.`service`=`services`.`id` WHERE `admins_services`.`admin_id`="'.$admin->id.'" LIMIT 10');
						$services->setFetchMode(PDO::FETCH_OBJ);

			while($service = $services->fetch())
			{
				if(!in_array($service->show_adm, array('', '1')))
					continue;

				$privileges .= $service->name != '' ? $service->name.' + ' : 'Неизвестно + ';
			}

			if($privileges != '')
			{
				$privileges = substr($privileges, 0, -3);

				if(!isset($users[$admin->user_id]))
				{
					$user = $pdo->query('SELECT `login`, `avatar` FROM `users` WHERE `id`="'.$admin->user_id.'" LIMIT 1');
							$user->setFetchMode(PDO::FETCH_OBJ);
					$user = $user->fetch();

					$users[$admin->user_id] = $user;
				}

				if(!$admin->user_id)
				{
					$users[$admin->user_id]->login = 'Неизвестно';
					$users[$admin->user_id]->avatar = '../files/avatars/no_avatar.jpg';
				}

				$tpl->load_template('admins.tpl');
					$tpl->set('{i}', $i);
					$tpl->set('{id}', $admin->id);
					$tpl->set('{auth}', $admin->name);
					$tpl->set('{active}', $admin->active);
					$tpl->set('{link}', $admin->link);
					$tpl->set('{price}', $admin->pirce);
					$tpl->set('{cause}', $admin->cause);
					$tpl->set('{user}', $admin->user_id);
					$tpl->set('{login}', $users[$admin->user_id]->login);
					$tpl->set('{avatar}', $users[$admin->user_id]->avatar);
					$tpl->set('{type}', $aType[$admin->type]);
					$tpl->set('{privileges}', $privileges);
				$tpl->compile('admins');
			}
		}

		$hide = '';

		if($tpl->result['admins'] == '')
		{
			$hide = 'disp-n';

			$tpl->load_template('content_none.tpl');
				$tpl->set('{class}', 'm-l-5 m-b-5 m-r-5 m-t-5');
				$tpl->set('{text}', 'Список администраторов пуст');
			$tpl->compile('admins');
		}

		$tpl->load_template('server_admins.tpl');
			$tpl->set('{id}', $server->id);
			$tpl->set('{name}', $server->name);
			$tpl->set('{hide}', $hide);
			$tpl->set('{admins}', $tpl->result['admins']);
		$tpl->compile('content');
	}

	if($tpl->result['content'] == '')
	{
		$tpl->load_template('content_none.tpl');
			$tpl->set('{text}', 'Список администраторов пуст, нет игровых серверов');
		$tpl->compile('content');
	}

	$tpl->show($tpl->result['content']);
?>